﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.WebControls;
using AntiXssEnc = Microsoft.Security.Application;
using VIRP;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabOrder : EfrBasePage
    {
        private const string ReferralKey = "LabOrder_Referrer";

        //private readonly LabOrderManager manager;
        //private WKF_CASE_ACTIVITY activity;
        private EfrInterfaceManager manager;

        private int? REFERRAL_ID
        {
            //get
            //{
            //    int? rEFERRAL_ID = 0;

            //    if (ViewState["REFERRAL_ID"] == null)
            //    {
            //        //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            //        ViewState["REFERRAL_ID"] = rEFERRAL_ID;
            //    }
            //    else
            //    {
            //        rEFERRAL_ID = ViewState["REFERRAL_ID"] as int?;
            //    }

            //    return rEFERRAL_ID;
            //}
            set
            {
                ViewState["REFERRAL_ID"] = value;
            }
        }

        private WKF_CASE WkfCase
        {
            get
            {
                WKF_CASE wkfCase = null;

                if (ViewState["WkfCase"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    ViewState["WkfCase"] = wkfCase;
                }
                else
                {
                    wkfCase = ViewState["WkfCase"] as WKF_CASE;
                }

                return wkfCase;
            }
            set
            {
                ViewState["WkfCase"] = value;
            }
        }

        private WKF_CASE_ACTIVITY Activity
        {
            get
            {
                WKF_CASE_ACTIVITY activity = null;

                if (ViewState["Activity"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    ViewState["Activity"] = activity;
                }
                else
                {
                    activity = ViewState["Activity"] as WKF_CASE_ACTIVITY;
                }

                return activity;
            }
            set
            {
                ViewState["Activity"] = value;
            }
        }

        private List<VIRP.EFR.BO.LAB_ORDER> LabOrders
        {
            get
            {
                List<VIRP.EFR.BO.LAB_ORDER> labOrders = null;

                if (ViewState["LabOrders"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    ViewState["LabOrders"] = labOrders;
                }
                else
                {
                    labOrders = ViewState["LabOrders"] as List<VIRP.EFR.BO.LAB_ORDER>;
                }

                return labOrders;
            }
            set
            {
                ViewState["LabOrders"] = value;
            }
        }

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/LabOrders/LabOrders.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx",
            "/Custom/EFR/LabResults/LabResultDetails.aspx"
        };

        public LabOrder()
        {
            //manager = new LabOrderManager();
            manager = new EfrInterfaceManager();

            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            //ReplacePageTitle();

            if (!IsPostBack)
            {
                int orderId;
                if (int.TryParse(Request.QueryString["activityId"], out orderId))
                {
                    GetRefreshLabOrder(orderId);

                    //ViewState["ReferralCaseId"] = Activity.WKF_CASE.REFERRAL_ID;
                    REFERRAL_ID = WkfCase.REFERRAL_ID;
                    //only for biological
                    if (Activity.STD_WKFACTIVITYTYPE_ID == 3)
                        SetupBioLabOrder();
                }

                SetReferringPage();

                Uri from = ViewState["referrer"] as Uri;
                if (VIRP.EFR.BO.UriUtility.IsValidPathSource(NavigationSources, from))
                {
                    SetOriginalReferringPage(ReferralKey);
                }
            }

            RangeValidatorLabRequestDateIsDate.MaximumValue = RangeValidatorLabelSampleReceivedDateIsDate.MaximumValue = DateTime.Today.ToShortDateString();
        }

        private void GetRefreshLabOrder(int oId)
        {
            WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, oId);
            if (activity != null)
            {
                WkfCase = ServiceInterfaceManager.WKF_CASE_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE_ID);
                LabOrders = VIRP.EFR.BLL.LAB_ORDERManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);
            }

            Activity = activity;
            //Activity = manager.getLabOrderByOrderID(oId);
            //Activity.SetAsChangeTrackingRoot();

            ReplacePageTitle("My Tasks > Lab Orders > " + Activity.STD_WKFACTIVITYSTS.NAME + " > Workflow ID : " + Activity.WKF_CASE_ID.ToString());
        }

        private void SetupBioLabOrder()
        {
            string tempText = string.Empty;
            lblSampleType.Text = "URINE";
            if (WkfCase != null && WkfCase.PATIENT != null && WkfCase.PATIENT.SPATIENT != null)
                tempText = VIRP_WEB.BaseCode.Helpers.FullName(WkfCase.PATIENT).Substring(0, 1) + WkfCase.PATIENT.SPATIENT.PatientSnum.Substring(WkfCase.PATIENT.SPATIENT.PatientSnum.Length - 4, 4);
            else
                tempText = "N/A";
            lblSampleIDNumber.Text = AntiXssEnc.Encoder.HtmlEncode(tempText);

            List<VIRP.EFR.BO.LAB_ORDER> labOrders = LabOrders;

            if (labOrders != null && labOrders.Count > 0)
            {
                VIRP.EFR.BO.LAB_ORDER order = labOrders.First();

                string shortDate = order.LAB_SEND_DATE.HasValue ? order.LAB_SEND_DATE.Value.ToString("yy") : DateTime.Today.ToString("yy");
                tempText = shortDate + " - " + "TEF" + order.LAB_ORDER_ID.ToString().PadLeft(5, '0');
                lblLabRequestNumber.Text = AntiXssEnc.Encoder.HtmlEncode(tempText);

                if (order.LAB_SEND_DATE.HasValue)
                {
                    LabRequestDate.Text = order.LAB_SEND_DATE.Value.ToShortDateString();
                }
                else
                {
                    if (Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided)
                    {
                        LabRequestDate.Text = String.Empty;
                    }
                    else
                    {
                        LabRequestDate.Text = DateTime.Now.ToShortDateString();
                    }
                }

                if (order.LAB_RECEIVED_DATE.HasValue)
                {
                    tempText = order.LAB_RECEIVED_DATE.Value.ToShortDateString();
                    LabSampleReceivedDate.Text = AntiXssEnc.Encoder.HtmlEncode(tempText);
                }
                if (order.LAB_RETURN_DATE.HasValue)
                {
                    tempText = order.LAB_RETURN_DATE.Value.ToShortDateString();
                    LabelLabReportDate.Text = AntiXssEnc.Encoder.HtmlEncode(tempText);
                }
                txtBSONumber.Text = order.BSO_NUMBER;
                txtTrackingNumber.Text = order.SHIPMENT_TRACKING_NUMBER;
                txtSampleInstructions.Text = order.SPECIAL_INSTRUCTION;
                txtSampleDescription.Text = order.SAMPLE_DESC;

                SetupAnalytes(order);
            }
            else
            {
                //new lab order doesn't have associated lab order before you save it 1st
                LabRequestDate.Text = DateTime.Today.ToString("d");
            }

            switch (Activity.STD_WKFACTIVITYSTS_ID)
            {
                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.New:

                    LabelForLabLabelReportDate.Visible = false;
                    LabelLabReportDate.Visible = false;
                    PrintButton.Enabled = false;
                    VoidButton.Enabled = true;
                    SaveButton.Enabled = false;
                    CompleteButton.Enabled = true;
                    LabRequestDate.Enabled = true;
                    ReOpenLabOrder.Enabled = false;
                    SaveButton.Text = "Save";

                    RequiredFieldValidatorLabRequestDate.Enabled = true;

                    SaveButton.ValidationGroup = "";

                    break;

                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.AwaitingResults:

                    LabelForLabLabelReportDate.Visible = false;
                    LabelLabReportDate.Visible = false;
                    PrintButton.Enabled = true;
                    VoidButton.Enabled = false;
                    SaveButton.Enabled = true;
                    CompleteButton.Enabled = false;
                    LabRequestDate.Enabled = false;
                    RequiredFieldValidatorLabRequestDate.Enabled = true;
                    ReOpenLabOrder.Enabled = false;
                    CancelButton.Text = "Back";
                    SaveButton.ValidationGroup = "LabOrderValidation";
                    SaveButton.Text = "Save";
                    ReOpenLabOrder.Enabled = false;

                    break;

                //Closed status
                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Closed:
                    LabelForLabLabelReportDate.Visible = true;
                    LabelLabReportDate.Visible = true;
                    CompleteButton.Enabled = false;
                    SaveButton.Enabled = false;
                    PrintButton.Enabled = true;
                    VoidButton.Enabled = false;
                    LabRequestDate.Enabled = false;
                    ReOpenLabOrder.Enabled = CheckWkfCaseStatusForReOpen(Activity.WKF_CASE_ID, VIRP.EFR.BO.WorkFlowActivityTypes.LabResult) ? true : false;
                    //ReOpenLabOrder.Enabled = manager.CheckWkfCaseStatusForReOpen(Activity.WKF_CASE_ID, VIRP.EFR.BO.WorkFlowActivityTypes.LabResult) ? true : false;
                    RequiredFieldValidatorLabRequestDate.Enabled = true;
                    CancelButton.Text = "Back";
                    SaveButton.ValidationGroup = "";
                    SaveButton.Text = "Save";
                    break;

                //void status
                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided:
                    LabelForLabLabelReportDate.Visible = false;
                    LabelLabReportDate.Visible = false;
                    CompleteButton.Enabled = false;
                    SaveButton.Enabled = true;
                    PrintButton.Enabled = false;
                    VoidButton.Enabled = false;
                    LabRequestDate.Enabled = false;
                    ReOpenLabOrder.Enabled = false;
                    RequiredFieldValidatorLabRequestDate.Enabled = false;
                    CancelButton.Text = "Back";
                    SaveButton.Text = "Un-Void";
                    SaveButton.ValidationGroup = "LabOrderValidation";

                    break;
            }
        }

        private void SaveCompleteLabOrder(Func<string> operation)
        {
            VIRP.EFR.BO.LAB_ORDER order = null;

            if (LabOrders != null && LabOrders.Count > 0)
            {
                order = LabOrders.First();

                SaveLabOrder(ref order);
            }
            else
            {
                order = new VIRP.EFR.BO.LAB_ORDER();

                SaveLabOrder(ref order);

                order.WKF_CASE_ACTIVITY_ID = Activity.WKF_CASE_ACTIVITY_ID;
                //LabOrders = VIRP.EFR.BLL.LAB_ORDERManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, order.WKF_CASE_ACTIVITY_ID);
                //Activity.LAB_ORDERs.Add(order);
            }
            order.LAB_ORDER_ID = VIRP.EFR.BLL.LAB_ORDERManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, order);

            //set questionnaire in-process status

            OpenCloseReferralAndWorkflowCase(WkfCase, operation);

            Activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Activity);
            //manager.Update(Activity);
            //FormViewWorkflowInformation.DataBind();
            GetRefreshLabOrder(Activity.WKF_CASE_ACTIVITY_ID);
        }

        //this is the function that gets all values from page controls to eventually save them in a database  
        private void SaveLabOrder(ref VIRP.EFR.BO.LAB_ORDER labOrder)
        {
            labOrder.LAB_SEND_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRequestDate.Text.Trim());
            labOrder.LAB_RECEIVED_DATE = Helpers.ConvertStringToNullable<DateTime>(LabSampleReceivedDate.Text.Trim());
            labOrder.LAB_RETURN_DATE = Helpers.ConvertStringToNullable<DateTime>(LabelLabReportDate.Text.Trim());

            labOrder.BSO_NUMBER = txtBSONumber.Text.Trim();
            labOrder.SHIPMENT_TRACKING_NUMBER = txtTrackingNumber.Text.Trim();

            labOrder.SPECIAL_INSTRUCTION = txtSampleInstructions.Text.Trim();
            labOrder.SAMPLE_DESC = txtSampleDescription.Text.Trim();

            labOrder.STD_REGISTRY_ID = UserSession.CurrentRegistryId;

            SaveAnalytes(labOrder);
        }

        private void SetupAnalytes(VIRP.EFR.BO.LAB_ORDER labOrder)
        {
            List<VIRP.EFR.BO.LAB_ORDER_DETAIL> listDetails = VIRP.EFR.BLL.LAB_ORDER_DETAILManager.GetItemsByLabOrder(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, labOrder.LAB_ORDER_ID);
            if (listDetails != null)
            {
                var selected = 0;
                foreach (VIRP.EFR.BO.LAB_ORDER_DETAIL detail in listDetails)
                {
                    int analyteTypeId = detail.STD_ANALYTETYPE_ID;
                    //analyte of "other" type 
                    if (analyteTypeId == 15)
                    {
                        OtherAnalyteCheck.Checked = true;
                        OtherAnalyteText.Text = detail.OTHER_ANALYTE_NAME;
                    }
                    else
                    {
                        ListItem item = AnalytesList.Items.FindByValue(analyteTypeId.ToString());
                        if (item != null)
                        {
                            //if we find factor nothing else to do here 
                            item.Selected = true;
                            selected++;
                        }
                    }
                }

                if (selected == 14)
                    AnalytesList.Items.FindByValue("0").Selected = true;
            }
        }
        private void SaveAnalytes(VIRP.EFR.BO.LAB_ORDER order)
        {
            List<VIRP.EFR.BO.LAB_ORDER_DETAIL> details = VIRP.EFR.BLL.LAB_ORDER_DETAILManager.GetItemsByLabOrder(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, order.LAB_ORDER_ID);
            if (details != null)
            {
                var otherValue = 15;
                //add other Analyte
                if (OtherAnalyteCheck.Checked)
                {
                    if (!otherValue.In(details.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
                    {
                        VIRP.EFR.BO.LAB_ORDER_DETAIL detail = new VIRP.EFR.BO.LAB_ORDER_DETAIL();

                        detail.LAB_ORDER_ID = order.LAB_ORDER_ID;
                        detail.STD_ANALYTETYPE_ID = otherValue;
                        detail.OTHER_ANALYTE_NAME = OtherAnalyteText.Text.Trim();

                        detail.LAB_ORDER_DETAIL_ID = VIRP.EFR.BLL.LAB_ORDER_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, detail);
                        //order.LAB_ORDER_DETAILs.Add(detail);
                    }
                }
                else
                {
                    if (otherValue.In(details.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
                    {
                        //analyte is in a database and was unselected so need to delete it 
                        VIRP.EFR.BO.LAB_ORDER_DETAIL detail = details.Where(lod => lod.STD_ANALYTETYPE_ID == otherValue).Single();
                        if (detail != null)
                            VIRP.EFR.BLL.LAB_ORDER_DETAILManager.Delete(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, detail.LAB_ORDER_DETAIL_ID);
                        //detail.SetAsDeleteOnSubmit();
                    }
                }

                foreach (ListItem item in AnalytesList.Items)
                {
                    int value = int.Parse(item.Value);

                    if (value > 0)
                    {
                        if (item.Selected)
                        {
                            if (value.In(details.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
                            {
                                //do nothing since referral is already in 
                            }
                            else
                            {
                                //need to generate and save a new analyte, as it's not presently in a database 
                                VIRP.EFR.BO.LAB_ORDER_DETAIL detail = new VIRP.EFR.BO.LAB_ORDER_DETAIL();

                                detail.LAB_ORDER_ID = order.LAB_ORDER_ID;
                                detail.STD_ANALYTETYPE_ID = value;

                                detail.LAB_ORDER_DETAIL_ID = VIRP.EFR.BLL.LAB_ORDER_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, detail);
                                //order.LAB_ORDER_DETAILs.Add(detail);
                            }
                        }
                        else
                        {
                            if (value.In(details.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
                            {
                                //analyte is in a database and was unselected so need to delete it 
                                VIRP.EFR.BO.LAB_ORDER_DETAIL detail = details.Where(lod => lod.STD_ANALYTETYPE_ID == value).Single();
                                if (detail != null)
                                    VIRP.EFR.BLL.LAB_ORDER_DETAILManager.Delete(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, detail.LAB_ORDER_DETAIL_ID);
                                //detail.SetAsDeleteOnSubmit();
                            }
                            else
                            {
                                //analyte is not in a database so no need to do anything
                            }
                        }
                    }
                }
            }
        }

        //protected override void LoadViewState(object savedState)
        //{
        //    base.LoadViewState(savedState);
        //    string activityXml = (string)ViewState["activityXml"];
        //    Activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activityXml);
        //}

        //protected override object SaveViewState()
        //{
        //    ViewState["activityXml"] = Activity.Serialize();
        //    return base.SaveViewState();
        //}

        protected void SaveButton_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                if (Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided)
                    Activity.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.New;

                SaveCompleteLabOrder(() => "Save");

                //SetSaveSuccessMessage();

                SetupBioLabOrder();

                ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void CancelButton_Click(object sender, EventArgs e)
        {
            RedirectToReferringPage();

            //DNS - Defect 827306
            //If redirect above fails, redirect to original referrer
            var navigatedFrom = VIRP.EFR.BO.SessionItemReference<Uri>.Get(Session[ReferralKey]);
            if (navigatedFrom != null)
            {
                Session.Remove(ReferralKey);
                Response.Redirect(navigatedFrom.PathAndQuery);
            }
        }

        protected void CompleteButton_Click(object sender, EventArgs e)
        {
            Activity.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.AwaitingResults;
            //this un-voids lab result so have to open or re-open workflow(case) if it's not open

            bool labResultExists = ActivityExists(Activity.WKF_CASE_ID, VIRP.EFR.BO.WorkFlowActivityTypes.LabResult);

            if (!labResultExists)
            {
                //create lab result _activity since it's no longer simulated 
                WKF_CASE_ACTIVITY NewActivity = new WKF_CASE_ACTIVITY();

                NewActivity.CREATED = NewActivity.UPDATED = DateTime.Now;
                NewActivity.CREATEDBY = NewActivity.UPDATEDBY = HttpContext.Current.User.Identity.Name;
                NewActivity.WKF_CASE_ID = Activity.WKF_CASE_ID;
                NewActivity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt16(VIRP.EFR.BO.WorkFlowActivityTypes.LabResult);
                NewActivity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.New);
                NewActivity.REPRESENTATIVE_NAME = Activity.REPRESENTATIVE_NAME;
                NewActivity.CONTACT_NAME = "Dr. Brown";

                NewActivity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, NewActivity);

                //NewActivity.SetAsChangeTrackingRoot(EntityState.New, true);
                //NewActivity.SetAsInsertOnSubmit();
                //manager.Update(NewActivity);
            }

            SaveCompleteLabOrder(() => "Complete");

            SetupBioLabOrder();

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        protected void PrintButton_Click(object sender, EventArgs e)
        {
            SuppressSaveSuccessMessage = true;

            Response.Redirect("~/Custom/EFR/LabOrders/TefscLaboratoryRequestReport.aspx?activityId=" + Activity.WKF_CASE_ACTIVITY_ID.ToString(), false);
        }
        protected void VoidButton_Click(object sender, EventArgs e)
        {
            LabRequestDate.Text = "";
            LabSampleReceivedDate.Text = "";

            Activity.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided;

            SaveCompleteLabOrder(() => "Void");

            SetupBioLabOrder();

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
        {
            //Copied this code from LabKitDetails

            REFERRAL parentReferral = ServiceInterfaceManager.REFERRAL_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentCase.REFERRAL_ID.GetValueOrDefault());
            if (parentReferral != null)
            {
                if (operation() == "Void")
                {
                    List<WKF_CASE> cases = ServiceInterfaceManager.WKF_CASE_GET_ALL_BY_REFERRAL(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentReferral.REFERRAL_ID);
                    if (cases != null)
                    {
                        bool blnIncomplete = false;
                        foreach (WKF_CASE c in cases)
                        {
                            if (c.WKF_CASE_ID != parentCase.WKF_CASE_ID && c.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed)
                            {
                                blnIncomplete = true;
                                break;
                            }
                        }
                        if (!blnIncomplete)
                            parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;
                    }

                    parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
                }
                else
                {
                    if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.InProcess)
                        parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.InProcess;

                    if (parentCase.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess)
                        parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
                }

                SuppressSaveSuccessMessage = true;
                parentCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentCase);
                parentReferral.REFERRAL_ID = ServiceInterfaceManager.REFERRAL_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentReferral);

                SuppressSaveSuccessMessage = false;
            }
        }

        //private void OpenCloseReferralAndWorkflowCase(Func<string> operation)
        //{
        //    ReferralManager rm = new ReferralManager();

        //    int wfCaseRefId;
        //    if (int.TryParse(ViewState["ReferralCaseId"].ToString(), out wfCaseRefId))
        //    {
        //        EFR_REFERRAL parentReferral = rm.getReferralByReferralID(wfCaseRefId);

        //        parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
        //        parentReferral.SetAsChangeTrackingRoot();

        //        WKF_CASE parentCase = parentReferral.WKF_CASEs.Where(a => a.WKF_CASE_ID == Activity.WKF_CASE_ID).First();

        //        if (operation() == "Void")
        //        {
        //            parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
        //            var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

        //            if (items.Count(a => a.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed) == 0)

        //                parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;
        //        }
        //        else
        //        {
        //            if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.InProcess)
        //                parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.InProcess;

        //            if (parentCase.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess)
        //                parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
        //        }

        //        SuppressSaveSuccessMessage = true;
        //        rm.Update(parentReferral);

        //        SuppressSaveSuccessMessage = false;
        //    }
        //}

        protected void Reopen_LabOrder_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                Activity.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.AwaitingResults;
                SaveCompleteLabOrder(() => "ReOpen");

                SetupBioLabOrder();

                ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private bool CheckWkfCaseStatusForReOpen(int wkfId, VIRP.EFR.BO.WorkFlowActivityTypes type)
        {
            bool isWorkflowValidForReOpen = false;
            List<WKF_CASE_ACTIVITY> activities = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wkfId);
            if (activities != null)
            {
                activities = activities.Where(s => s.STD_WKFACTIVITYTYPE_ID == (int)type && (s.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess || s.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.New) && s.ARCHIVED_FLAG == false).ToList();
                if (activities.Count > 0)
                    isWorkflowValidForReOpen = true;
            }

            return isWorkflowValidForReOpen;
        }

        public bool ActivityExists(int wkfId, VIRP.EFR.BO.WorkFlowActivityTypes type)
        {
            bool activityExists = false;
            List<WKF_CASE_ACTIVITY> activities = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wkfId);
            if (activities != null)
            {
                activities = activities.Where(s => s.STD_WKFACTIVITYTYPE_ID == (int)type && s.ARCHIVED_FLAG == false).ToList();
                if (activities.Count > 0)
                    activityExists = true;
            }

            return activityExists;
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}